/*------------------------------------------------------------------------------*
 * File Name: GraphObjTools.h 													*
 * Creation: Sim 01-08-2010														*
 * Purpose: OriginC Header H file												*
 * Copyright (c) Originlab Corp. 2006											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS								*
 *	Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS			*
 *	Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS	*
 *	Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS						*
 *	Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT						*
 *	Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES			*
 *	Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU				*
 *	Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY			*
 *	Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
 *	Folger 02/04/10 SUPPORT_AUTO_FOR_X_SCALE									*
 *	Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS						*
 *  Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *	Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU						*
 *	Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY		*
 *	Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR	*
 *	Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS				*
 *	Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT							*
 *	Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
 *	Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS			*
 *	Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS				*
 *	Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2			*
 *	Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU				*
 *	Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS		*
 *	Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG		*
 *	Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY			*
 *	Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL	*
 *------------------------------------------------------------------------------*/

#ifndef _GROBJ_TOOLS_H_
#define _GROBJ_TOOLS_H_

enum
{
	GROBJEVENTS_FROM_EVENT_FUNCTION			= 0x00010000,
	GROBJEVENTS_SELF_DELAY_EVENT			= 0x00020000,	///Sophy 7/19/2010 ORG-25-P8 MULTAI_GADGETS_ON_SAME_LAYER_FAIL_TO_UPDATE_CORRECTLY_ON_RESCALE
};

void graphobjtool_events(GraphObjTool& iTool, LPCSTR lpcszMainObjName, int nEvent, int nMsg = 0);

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Sophy 9/13/2008 GRAPH_OBJ_TOOL

///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
#define	STR_VERSION_ATTRIB	(GetXFName() + "ROIVersion")
#define	STR_XFNAME_ATTRIB	"XFName"	///Sophy 3/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY need this attribute in storage to identify ROI tool type
///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY
///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
enum {
	GOT_BTN_OUTPUT	= 0x0001,
	GOT_BTN_EDIT	= 0x0002,
	///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	GOT_BTN_UPDATE_LIST	= 0x0003, //this CmdID is currently used for quick fit tool, but can also be used in other ROI classes
	///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	GOT_BTN_CLOSE	= 0x0004,
	GOT_BTN_EXPAND	= 0x0005,
	GOT_BTN_FIT		= 0x0006,
	GOT_BTN_FINDXY	= 0x0007,
	GOT_BTN_CONTEXT	= 0x0008,
	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	GOT_BTN_SAVE_THEME	= 0x0009,
	///end ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	GOT_BTN_GOTO_REPORT	= 0x000A,	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	GOT_BTN_UPDATE_LAST_OUTPUT	= 0x000B, /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	GOT_BTN_SEL_ALL_PLOTS		= 0x000C,
	GOT_BTN_DATA_EDIT			= 0x000D,
	GOT_BTN_APPLY				= 0x000E,	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	GOT_BTN_FIXED_MASK	= 0xFFFF0000,
	GOT_BTN_FLEX_MASK	= 0x0000FFFF,
	GOT_BTN_PLOTS		= 0x00010000,
	GOT_BTN_FUNCTION	= 0x00020000,
	///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	GOT_BTN_THEMES		= 0x00030000,
	///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	GOT_CMD_CUSTOM		= 0x00040000,
};

enum {
	ROI_OPTION_IGNORE_EVENT		= 0x0001,
	ROI_OPTION_RESET_LABEL_POS	= 0x0002,	///Sophy 2/2/2010 RESET_TOP_LABEL_POS_WHEN_CHANGE_FUNC_OR_PREFERENCES
	ROI_OPTION_VERSION_CHECKED	= 0x0004,	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	ROI_OPTION_SCALE_CHANGED	= 0x0008,	///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
	ROI_OPTION_ON_MOVE_EVENT	= 0x0010,
	ROI_OPTION_IGNORE_DESTROY	= 0x0020,	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	ROI_OPTION_DO_CONTEXT		= 0x0040,
};

enum {
	ROI_OP_GET, 
	ROI_OP_SET,
	ROI_OP_REMOVE,
	ROI_OP_RESET,
};

///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS
#define	STR_GETN_HANDLE			"GETNHandle"
#define	STR_EVENT_HANDLE		"GETNEVT"

#define	GETN_GLOBAL_EVT(_PFN)	{PEVENT_GETN __dfn = _PFN;DWORD _dw_fn = (DWORD)__dfn;\
 if(_dw_fn) {string strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_GETN_HANDLE, strTemp);}}

#define	GET_GETN_EVT(_Node, _pfn)	PEVENT_GETN _pfn = NULL; {string strTemp = ""; if(_Node)_Node.GetAttribute(STR_GETN_HANDLE, strTemp);\
 if (!strTemp.IsEmpty()) { DWORD _dw_fn = (DWORD)atol(strTemp); _pfn = (PEVENT_GETN)_dw_fn;}}
///end ///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS

///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
#define	STR_MAINOBJ_NAME_ATTRIB	"MainObjName"
#define	STR_APPLY_HANDLE		"ApplyHandle"
#define	STR_APPLY_EVT			"APPLYEVT"
#define	GETN_APPLY_EVT(_PFN)	{PAPPLY_FUNC __dfn = _PFN;DWORD _dw_fn = (DWORD)__dfn;\
 if(_dw_fn) {string strTemp = _dw_fn;_tmpSubNode.SetAttribute(STR_APPLY_HANDLE, strTemp);}}
 	
#define	GET_APPLY_EVT(_Node, _pfn)	PAPPLY_FUNC _pfn = NULL; {string strTemp = ""; if(_Node)_Node.GetAttribute(STR_APPLY_HANDLE, strTemp);\
 if (!strTemp.IsEmpty()) { DWORD _dw_fn = (DWORD)atol(strTemp); _pfn = (PAPPLY_FUNC)_dw_fn;}}
 	
bool	ROI_apply_handle(TreeNode& tr);
///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

///Sophy 2/10/2010 QA81-15097 ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED
bool	is_active_graphlayer_xyexchanged();
///end ROI_TOOLS_DONT_WORK_WHEN_XY_AXIS_EXCHANGED

int		roi_tool_option_access(DWORD dwTestBit, int nOption = 0);
#define	QUERY_ROI_TOOL_OPTION(_dwTestBit)		(roi_tool_option_access(_dwTestBit, ROI_OP_GET) ? TRUE : FALSE)

///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
///Kyle 03/15/2010 IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ
//bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, vector<int>& vnI1 = NULL, vector<int>& vnI2 = NULL);
bool	is_plot_for_ROI(const DataPlot& dp, const GraphObject& gr, LPCSTR lpcszTag = NULL, vector<int>& vnI1 = NULL, vector<int>& vnI2 = NULL);
///End IS_PLOT_FOR_ROI_GIVE_OPTION_TO_SPECIFY_THE_NAME_TO_TAG_A_DATAOBJ

bool	update_roi_position(GraphObject& go, double dLeft, double dRight, double dTop, double dBottom);

#define	STR_ROI_MAIN_OBJ_STORAGE	"ROIMainObjName"
bool	get_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, string& strObjName);
bool	set_ROI_main_obj_name(const GraphLayer& gl, LPCSTR lpcszROIType, LPCSTR lpcszObjName = NULL);
///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL

///Kyle 03/12/2010 PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT
bool check_get_roi_x_position(const GraphLayer& gl, string& strLeft, string& strRight, LPCSTR lpcszRect = NULL);

int get_source_data_plot_index_from_ROI(const GraphObject& go);
///End PICK_PEAK_SHARE_CODE_WITH_QUICK_FIT

///Sophy 1/18/2010 QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS
class ROIToolOptionAccessHelper
{
public:
	ROIToolOptionAccessHelper(DWORD dwEventID)
	{
		if ( (m_dwEventID = QUERY_ROI_TOOL_OPTION(dwEventID) ? 0 : dwEventID) )
			roi_tool_option_access(dwEventID, ROI_OP_SET);
	}
	~ROIToolOptionAccessHelper()
	{
		if ( m_dwEventID )
			roi_tool_option_access(m_dwEventID, ROI_OP_REMOVE);
	}
private:
	DWORD	m_dwEventID;
};
///End QUICKFIT_USE_ONE_BTN_TO_HANDLE_FINDXY_EVENTS

#define	STR_ROI_LABEL	_L("ROI Box")
#define	STR_PREFERENCES	_L("Preferences")
#define	STR_FILL_COLOR	_L("Fill Color")
/// Iris 2/01/2010 UPDATED_ACCORDING_TO_WIKI
//#define	STR_GOTO_REPORT	_L("Go to Report")
#define	STR_GOTO_REPORT	_L("Go to Report Worksheet")
///End UPDATED_ACCORDING_TO_WIKI
#define	STR_TOOLNAME	_L("Show Tool Name")
#define	STR_SHOW_PLOTS	_L("Change Data")
/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
//#define	STR_DO_OUTPUT	_L("Output Report")
#define	STR_DO_OUTPUT	_L("New Output")
#define	STR_UPDATE_LAST_OUTPUT	_L("Update Last Output")
///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
#define	STR_SAVE_THEME	_L("Save Theme...")	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define	STR_DO_THEMES	_L("Load Theme")
///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
#define	STR_DO_EDIT		_L("Preferences...")
#define	STR_EXPAND_AREA	_L("Expand to Full Plot Range")
///end CLEAN_CODE_FOR_ROI_TOOLS
//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE, I added code related to lpcszMainObjName to allow in constructor and optional for OnMove
class	GraphObjTool
{
public:
	GraphObjTool(LPCSTR lpcszMainObjName = NULL);
	BOOL	IsValidLayer() {if(m_gl) return true; else return false;}
	BOOL	IsValidGrObj() {if(m_go) return true; else return false;}
	BOOL	SetTree( const TreeNode& tr ); //Sophy, currently, we just need to save information of m_go( main graph object )
	BOOL	GetTree( TreeNode& tr );
	//virtual BOOL OnDestroy(){return true;}
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	virtual void	OnEvent(int nEvent, int nMsg = 0);
	//----
	//----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	///---Sim
	//virtual BOOL Init();
	virtual BOOL Init(LPCSTR lpcszMainObjName);
	///---End Sim
	
	BOOL	GetMainObjName(string& strObjName);
	///Sophy 1/4/2010 QA80-14904-S1 SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	//void	DestroyInternal();
	//virtual	bool	DoShowPlots(){ return false; }
	//virtual	bool	DoOutput(){return false;}
	//virtual	bool	DoEdit(){return false;}
	//virtual	bool	DoFunction(){ return false; }
	//virtual	bool	CheckAttachObjs(){ return false; }
	///end SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
private:
	bool	connectToObj(LPCSTR lpcszName);
	//void	saveClassInfo();
	//bool	readClassInfo();
	//-----
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	bool	saveClassInfo();
	bool	loadClassInfo();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	string	getAttObjName(int nObjID);

protected:
	virtual	bool CheckROIVersion(){ return true; }	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	virtual void OnMoving();
	virtual BOOL OnMove() {return true;}
	//----
	virtual BOOL OnPreMove();

	/// Kenny 03/05/2010 QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	virtual BOOL OnPlotChanged()	{ return TRUE; }
	/// End QA81-14832 QUICK_FIT_WRONG_AUTO_PREVIEW_FITTED_CURVE_COLOR
	
	/// Fisher 7/20/09 QA80-13975 	HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	///Sophy 12/3/2009 QA80-14686 CENTRALIZE_CODE_FOR_UPDATE_RESULT_ON_RESCALE_GRAPH
	//virtual BOOL OnRescale() {return true;}
	virtual	BOOL IsDelayUpdate(){ return TRUE; }	///Sophy 2/8/2010 ROI_STATS_CURVE_NEED_TO_DELAY_HANDLE_SCALE_CHANGE
	virtual BOOL OnRescale() { return InvalidateResults();}
	virtual BOOL InvalidateResults(){ return OnMove(); }
	///end CENTRALIZE_CODE_FOR_UPDATE_RESULT_ON_RESCALE_GRAPH
	/// End HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL
	///Sophy 12/4/2009 QA80-14799 EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	virtual	BOOL OnMasked(){ return InvalidateResults();}
	///end EXPOSE_DATAMASK_EVENT_TO_OC_GRAPHOBJECT
	
	//---- CPY 9/26/08 QA70-12266 ADDTOOL_XF_NEEDS_PROJ_VAR_TO_INDICATE_THEY_ARE_STILL_ACTIVE
	virtual string GetSignature() {
		ASSERT(false);
		return "xf_addtool_unknown";
	}
	int 	GetTotalNumTools();
	virtual BOOL OnDestroy();
	bool	Attach(LPCSTR lpcszMainObjName);//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	///Jasmine 02/27/09 GraphVerticalCursor_WANT_IT_PROTECTED
	int 	referenceCount(bool bInc); // true to increment, false to decrement
	///End GraphVerticalCursor_WANT_IT_PROTECTED
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual bool	SaveClassInfo(TreeNode& tr) { return true; }
	virtual bool	LoadClassInfo(const TreeNode& tr) { return true; }
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
private:

	///Sandy 2008-12-23 add
	virtual void 		getBoundingBoxInfo(string& str);
	//end 
	
protected:
	//-----
	// returns <0 for err, 1 if already existed and type correct then just get out, 0 if normal creation on empty slot
	// nParam if > 0 might be used for additional setting, like font size if text
	int		CreateAttachment(GraphObject& go, int nObjID, int nPos, int nObjType = GROBJ_TN_TEXT, LPCSTR lpcszInitText = NULL, int nParam = -1);
	int		GetAttachment(GraphObject& go, int nObjID);
	///Sophy 1/14/2010 MOVE_CLOSE_BUTTON_TO_BASE_CLASS
	virtual	string	GetXFName() { return ""; }
	virtual	int		CreateAttachments();
	virtual	int		GetAttachments();
	///end MOVE_CLOSE_BUTTON_TO_BASE_CLASS
	///Sophy 4/14/2010 BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS
	virtual	int		CheckCreateAttachments(){ return 0; }
	///end BACKWORD_COMPATIBILITY_SUPPORT_FOR_GADGET_ATTACHMENTS

	///-------Sandy 2008-12-9 add color option
	///----- Sandy 2008-12-2 add ployline as one kind of free line
	//int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0);
	//int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0,  int nLineType = GROBJ_TN_LINE2);
	int		CreateAttachedFreeLine(GraphObject* pgo=NULL, int nFreePos = 0,  int nLineType = GROBJ_TN_LINE2, int nColor = SYSCOLOR_BLACK);
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	////----- CPY 9/17/08 CLEANUP_CODE_RELATED_TO_USING_BASE_CLASS_SET_TREE
	////int		GetAttachmentCount();
	//// this is just a utility function but I see no better place to put this so leave here for now.
	void AddNewLine(string& str, string strNew);
	////-----
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual	int*	GetXFEventHandlersState() { return NULL; }	///Sophy 6/10/2010 ORG-48-P14 BETTER_EVENT_HANDLE_FOR_PREFERENCE_IN_ROI_TOOLS move from derived class

	///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	//virtual	int		CreateAdvancedButtons(LPCSTR lpcszXFName, DWORD dwCtrl = GOT_BTN_PLOTS | GOT_BTN_OUTPUT | GOT_BTN_EDIT | GOT_BTN_CLOSE);
	///end CLEAN_CODE_FOR_ROI_TOOLS
	
protected:
	GraphPage 	m_gp;
	GraphLayer 	m_gl;
	GraphObject m_go;
	GraphObject m_goClose;
	string		m_strGrName;
	
	vector<int>		m_vnObjIDs;
	vector<string>	m_vsObjNames;
	//vector<int>		m_vnObjTypes;
	//vector<int>		m_vnObjPositions;
	OGRGAP		m_gapCtrl;

private:
	int				m_nRightTopObjs;
};
///end GRAPH_OBJ_TOOL

GraphObject& get_master_gr(GraphObject &go);/// Fisher 2008-9-19

//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
enum {
	GCTC_FREE_FORM_RECT = 0x0001,
};
//---- end

///Sophy 12/17/2009 QA80-14598-P4 RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN
//!!!! new enum item should all use high 32bits of the DWORD, as these value will be combined with TREE2STR_CHECK_USER_LABEL, etc. !!!!//
enum {
	OUTTREE_USE_TAGNAME_IN_SCRIPT_WIN = 0x00010000,
};
///end RISE_TIME_TOOL_NEED_CREATE_LONGNAME_IN_RESULT_COLUMN

///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
enum {
	GOT_OBJ_PLOTS	= 1,
	GOT_OBJ_OUTPUT,
	GOT_OBJ_EDIT,
	GOT_OBJ_CLOSE,
	GOT_OBJ_FUNCTION,
	GOT_OBJ_CONTEXT,
	GOT_OBJ_LABEL,
	GOT_OBJ_NAME,
	GOT_OBJ_TOTAL,
};
///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS

enum {
	SHAPE_RECT,
	SHAPE_CIRCLE,
};

enum {
	DATA_SELECTED_CURVE,
	DATA_ALL_CURVES
};

///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
enum {
	GROBJ_MASKED_AS_MISSING		= GDPS_AFTER_MASK,	//0x0001, use in VC level
	GROBJ_SKIP_ALL_MASKED_DATA	= 0x00010000,		//use high word as in OC level
};
#define	GROBJ_DATA_DEFAULT	(GROBJ_MASKED_AS_MISSING | GROBJ_SKIP_ALL_MASKED_DATA)
///end ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
/// Fisher 2008-9-13	GRAPH_OBJ_CURVE_TOOL
class GraphObjCurveTool : public GraphObjTool
{
public:
	GraphObjCurveTool(LPCSTR lpcszMainObjName = NULL);
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual BOOL Init(LPCSTR lpcszMainObjName);
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	//int 	Create(LPCSTR lpcszOCFuncName, int color, DWORD dwCntrl = 0, const TreeNode& trGUI = NULL); //---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS	
	int 	Create(LPCSTR lpcszOCFuncName, DWORD dwCntrl = 0, const TreeNode& trGUI = NULL, int nROIShape = SHAPE_RECT); //---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS	
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	//virtual bool	CreateAttachObjs();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	virtual void	OnEvent(int nEvent, int nMsg = 0);
	bool	DoContext();

	///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	void			UpdateThemeFileInGUITree(TreeNode& trGUI);
	///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG move from protected
	bool	SetGUITree(const TreeNode& trGUI);
	///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG

	virtual	BOOL	SetReportWorksheet(LPCSTR lpcszWorksheetName){ return FALSE; } ///Sophy 6/25/2010 ORG-25-P5 UPDATE_REPORT_SHEET_NAME_FROM_GADGETTOOL_DLG

protected:
	
	///Sophy 2/5/2010 FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS
	virtual	bool	UpdateBranchIDs(TreeNode& trGetN, TreeNode& trGUI);
	///end FAIL_TO_LOAD_THEME_WITH_DUPLICATED_IDS
		
	///Sophy 2/4/2010 QA80-15080 VERSION_CHECKING_FOR_ROI_COMPATIBILITY
	bool	SetVersion();
	virtual	double	GetVersion(){ return 8.102; } //set current ROI tools' version to 81SR2, if any tool's version updated, need to overwrite this member and return a bigger value.
	//virtual
	bool	CheckROIVersion();
	///end VERSION_CHECKING_FOR_ROI_COMPATIBILITY

	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	BOOL	RemakeGUITree();
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2

	//---- CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
	//virtual BOOL GetData(DataPlot& dp, int& i1, int& i2);
	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//virtual 	BOOL GetData();
	BOOL		GetData(DWORD dwCtrl = GROBJ_DATA_DEFAULT);	//I do NOT think this method needs to be virtual member.
	///end ///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	//----
	/// YuI 10/09/08 QA70-12265-P3 CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER
	///Sophy 12/14/2009 QA80-14686-P2 DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	//virtual 	BOOL GetData(vector& vX, vector& vY	);
	 BOOL		GetData(vector& vX, vector& vY, DWORD dwCtrl = 0);
	///end DATAPLOT_GET_DATAPOINTS_NEED_TO_SKIP_MASKED_DATA
	/// end CURVE_STATS_QUICK_TOOL_MUST_BE_SMARTER

	///Sophy 1/25/2010 SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS
	virtual		int	GetPointsLimit(){ return 2; }
	///end SHOW_WARNING_ON_NOT_GETTTING_ENOUGH_DATA_POINTS

	///Sophy 8/26/2009 QA80-14169 MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
	virtual	bool	MakePrintable(GraphObject& go) { return set_go_printable(go); }
	///end MAKE_GRAPHOBJECT_FOR_PROGRAMMING_CONTROL_PRINTABLE
	///Sophy 8/21/2009 QA80-14175 CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	int		UpdateMainRect(const TreeNode& trGUI);
	///end CREATE_ALL_NODES_IN_ONE_TREE_TO_GET_RID_OF_OPTIONS_BRANCH
	// return < 0 if no preview graph, 1 = initial show, 0 = already shown 
	// this function will always check and create wks if has been deleted by user
	int		CheckShowPreview();
	// return < 0 if no temp wks, 1 = initial wks, 0 = already have temp wks 	
	// this function used when there is wks but no separate preview graph 
	int		CheckPreviewDataWks(bool bCreate = true);//---- CPY 7/20/09 QA70-13575 HANDLE_RESCALE_EVENT_FOR_GRAPH_OBJ_TOOL added bCreate
	string	GetPreviewGraphName() {return m_strPreviewGraphName;}
	//---- CPY 9/27/08 CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	///Sophy 6/13/2010 ORG-23-S5 SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	//bool	SetGUITree(const TreeNode& trGUI); move to public
	///end SHOW_APPLY_BUTTON_FOR_INTERP_PREFERENCE_DLG
	bool	GetGUITree(Tree& trGUI);
	bool	SetResultsTree(const TreeNode& trResults);
	virtual bool GetResultsTree(TreeNode& trResults);
	bool    GetResultsTree(TreeNode& trResults, LPCSTR lpcszTagName);///Sandy add 2009-2-24 get result tree by clone sub-tree of gui
	void	ConnectToTempPreviewDataAndGraph(); 
	//virtual
	BOOL	OnDestroy();
	//
	//virtual 
	BOOL OnMove();
	//---- end CENTRALIZE_ADD_RECT_FOR_ALL_TOOLS
	
	void 	OutputResultTree(bool bToScript, bool bToResLog, bool bAppendWks, string strWksPageName, DWORD dwCtrl);///Sandy 2009-2-25 add CENTRALIZE_TO_BASE_CLASS_GROBJ_UTILS
	void 	GetRectCoordinate(double& dLeft, double& dRight, double& dTop = NULL, double& dBottom = NULL);
	
	///Sophy 11/26/2009 EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
	void	UpdateGUITree(TreeNode& trGUI);
	virtual	string	GetXFName(){ return ""; }
	virtual	string	GetToolName(){ return ""; } ///Sophy 1/22/2010 CENTRALIZE_OPEN_PREFERENCE_DIALOG_TO_BASE_CLASS
	virtual	string	GetPreferenceTitle(){ return ""; }
	virtual	BOOL	GetReportWorksheet(Worksheet& wksReport){ return FALSE; }	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	///EVT_HANDLER_IN_TREENODE_INVALID_WHEN_RESTART_ORIGIN
	///Sophy 1/18/2010 CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	virtual	TreeNode	GetFillColorNode(const TreeNode& trGUI);
	///end CLEAN_CODE_SUPPORT_FLEXIBLE_COLOR_SETTING_ACCESS
	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	virtual	TreeNode	GetToolNameNode(const TreeNode& trGUI);
	///end SHOW_TOOLNAME_FOR_ROI_TOOLS
	virtual	bool	UpdateAttachments(){ return false; }	///Sophy 10/15/2010 ORG-1263-P1 UPDATE_INDICATOR_SETTINGS_FOR_RISETIME_TOOL
	
	/// Iris 1/27/2010 ADD_LEFTX_RIGHTX_IN_ROI_TAB
	// return the left x scale and right x scale value.
	/// Iris 2/21/2010 REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	//virtual bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1) { return false; }
	///Sophy 3/5/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	//virtual bool CheckGetMainObjectXPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& bFixWidth) { return false; }
	virtual bool CheckGetMainObjectPositionFromGUITree(const TreeNode& trGUI, double& x0, double& x1, bool& pbFixWidth, double& y0, double& y1) { return false; }
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	///End REMOVE_AUTO_CHECKBOX_REPLACE_WITH_FIX_WIDTH_CHECKBOX
	virtual bool CheckSetMainObjectXPosition(double& x0, double& x1);
	///End ADD_LEFTX_RIGHTX_IN_ROI_TAB
	///Kyle 09/08/2010 ORG-998-P6 SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY
	virtual bool GetMainObjectXPosition(double& x0, double& x1);
	///End SHOW_BASELINE_INSIDE_THE_RECTANGLE_ONLY
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	virtual bool	SaveClassInfo(TreeNode &tr);
	virtual bool	LoadClassInfo(const TreeNode &tr);
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	///Sophy 1/4/2010 QA80-14904-S1 SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	void	Destroy();
	//virtual	bool	DoShowPlots(); CPY 2/2/10 QA81-15066 CONTEXT_MENU_POPUP_POSITION_MAKE_CONSISTENT removed
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	//virtual	bool	DoOutput(){ return false; }
	virtual	bool	DoOutput(bool bUpdateLastOutput){ return false; }
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	virtual	bool	IsCloneMainObj(){ return false; }
	bool	SetCloneMainObjName(LPCSTR lpcszName, LPCSTR lpcszTextName);
	bool	GetCloneMainObjName(string& strName, string& strTextName);
	///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	virtual	bool	DoEdit(HWND hWndParent = NULL);
	//virtual	bool	DoFunction(){ return false; }
	virtual	bool	UpdateInnerAttachments();
	//virtual	bool	CheckAttachObjs(){ return false; }
	///end SUPPORT_FLEXIBLE_ATTACHED_GROBJ_FOR_ROI_TOOLS
	
	///---Sim 01-08-2010 QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	//virtual
	int		CreateAttachments();
	//virtual
	int		GetAttachments();
	///---END QA81-14930 CLEAN_GRAPH_OBJ_TOOLS
	
	bool	UpdateTopLabel(LPCSTR lpcszText = NULL, bool bShow = true);	///Sophy 1/23/2010 MAKE_QUICK_CURVE_STATS_AS_STANDARD_ROI_TOOL
	bool	SetLabelTransparent(GraphObject& goLabel);	///Sophy 4/12/2010 QA81-15290 LABELS_INSIDE_ROI_SHOULD_NOT_BE_WHITEOUT
	int		AddPlots(Menu& pm, uint& nPosition);
	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	virtual	bool	IsPlotForROI(const DataPlot& dp);
	virtual	bool	UpdatePlotsMenu(Menu& pm, uint& nPosition);
	virtual	bool	IsSupportMultiPlots() { return false; }
	virtual	bool	SetMultiPlotsState(bool bOn = true);
	bool	DoSelAllPlots();
	bool	GetMultiPlotsState();
	virtual	bool	IsSupportEditData(){ return false; }
	bool	AddDataEdit(Menu& pm, uint& nPosition);
	bool	DoEditData(HWND hWndParent = NULL);
	bool	UpdateData(int nOpera, int nDataRegion, int nApplyTo, double dNewVal);
	///end EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	/// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	virtual bool AddUpdateLastOutputSubmenu(Menu& pm, uint& nPosition) { return false; }
	///End MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	///Kyle 03/08/2010 CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
	virtual bool OnCmdCustom(int nCmdID)		{	return false;	}
	///End CUSTOM_CMD_IN_CONTEXT_MENU_OF_GRAPH_OBJ_TOOLS
	bool	AddGotoReport(Menu& pm, uint& nPosition);	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	bool	DoActiveReport();	///Sophy 1/26/2010 ADD_GO_TO_REPORT_TABLE_MENU_IN_CONTEXT
	bool	DoExpand();
	bool	DoSaveTheme();	///Sophy 1/19/2010 QA80-14832 ADD_SAVE_THEME_AS_IN_CONTEXT_MENU_FOR_ROI_TOOLS
	bool	CheckUpdateToolName();	///Sophy 1/19/2010 QA80-14832 SHOW_TOOLNAME_FOR_ROI_TOOLS
	bool	OnSetPlot(int nIndex); 	///Sophy 3/8/2010 EXTEND_ROI_SHAPE_FOR_CLUSTER_TOOL
	bool	SetPlot(int nIndex);
	bool 	GetSelectedPlot(DataPlot& dp); /// Iris 2/20/2010 MOVE_REPLACE_LAST_OUTPUT_TO_CONTEXT_MENU
	virtual	bool	UpdateContextMenu(Menu& pm, uint& nPosition){ return false; }
	bool	RemoveMenu(Menu& pm, uint& nPosition, uint nDeletePos = 0); //since in XF it is impossible to call member function without including Control.h(but we are not suggested to use dialog relative header in XF)
	virtual	bool	DoFit(){ return false; }
	virtual	bool	DoFindXY(){ return false; }
	virtual	bool	SetFunction(int nIndex){ return false; }
	///Sophy 1/15/2010 ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	virtual	bool	DoUpdateList(){ return false; }
	///end ADD_EDIT_FUNCTION_LIST_IN_CONTEXT_MENU_FOR_QUICKFIT_ROI
	virtual	bool	UpdateThemeTree(TreeNode& trThemeTree);	///Sophy 1/21/2010 QA80-14832 DISPLAY_DEFAULT_THEME_NAME_WHEN_SAVE_THEME_FOR_ROI_TOOL

	///------ Folger 02/01/10 CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS
	string			GetCurrentThemeName();
	///------ End CURRENT_THEME_NAME_SHOULD_SHOW_WHEN_SAVE_THEME_AS_IN_ROI_TOOLS

	///------ Folger 02/04/10 SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU
	virtual	bool	UpdateROIGUI();
	virtual	bool	DoFunction()	{ ASSERT(FALSE); return false; }
	
	/// Iris 2/25/2010 TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	void	BeforeExpandRect(DataPlot& dp, double& dMinX, double& dMaxX, double& dMinY, double& dMaxY);
	///End TO_FIX_ALWAYS_CHANGE_LAYER_SCALE_WHEN_EXPAND_FULL_RANGE
	///Sophy 4/8/2010 EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS
	void	ExpandROI(double dMinX, double dMaxX, double dMinY, double dMaxY);
	///end EXPAND_FULL_RANGE_SUPPORT_MULTIPLE_DATAPLOTS

	void			AddThemes(Menu& pm);

	virtual	void	UpdateGUIOnThemeChange(TreeNode& trGUI);
	///------ End SUPPORT_LOAD_THEME_IN_ROI_TOOLS_CONTEXT_MENU

	///------ Folger 02/23/10 ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
	virtual	BOOL	IsExpandable()		{ return TRUE; }
	virtual	void	DoExpand(DataPlot& dp);
	///------ End ROI_TOOLS_DO_EXPAND_FAILS_TO_PLACE_BUTTONS_CORRECTLY
	
	///Sophy 4/9/2010 QA81-15290 QUICK_STATS_SHOW_PREVIEW_LINE_LABELS
	virtual	bool	CloneAttachments(GraphObject& goCloneMain);
	bool		CloneAndConnect(GraphObject& goMain, GraphObject& goSrc);
	///end QUICK_STATS_SHOW_PREVIEW_LINE_LABELS
	
	///Sophy 4/13/2010 SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU
	bool		InsertPopup(Menu& pm, uint nPosition, LPCSTR lpcszLabel, const vector<string>& vsItems, const vector<int>& vnCmdIDs, int nCheckIndex = -1);
	bool		InsertMenuItem(Menu& pm, uint nPosition, LPCSTR lpcszLabel, int nCmdID, UINT nFlags);
	///end SUPPORT_CHANGE_DERIV_ORDER_FROM_CONTEXT_MENU

protected:	
	string		m_strGraphTemplate;
	string		m_strPreviewGraphName;
	string		m_strPreviewGraphLongName;
	string		m_strPreviewDataWksName;
	string		m_strPreviewDataWksLongName;
	//WorksheetPage m_wp; CPY 9/13/08, no need for this as we assume only one sheet
	//GraphPage 	m_gpPreview;
	Worksheet	m_wks;
	GraphLayer	m_glPreview;
	///Sophy 1/5/2010 QA80-14904-S1 CLEAN_CODE_FOR_ROI_TOOLS
	GraphObject	m_goLabel;
	GraphObject	m_goPlots;
	GraphObject	m_goOutput;
	GraphObject	m_goEdit;
	GraphObject	m_goContext;
	GraphObject m_goToolName;
	///end CLEAN_CODE_FOR_ROI_TOOLS
	
	//---- CPY 10/1/08 MOVE_DATA_DISPLAY_CODE_TO_BASE_CLASS
	DataPlot	m_dp;
	int			m_i1, m_i2;
	double		m_x1, m_x2;
	//----
	vector		m_vX, m_vY;	///Sophy 5/4/2010 QA82-15364-P2 ROI_TOOLS_OPTION_FOR_SKIP_ALL_MASKED_DATAPOINTS
	
private:
	///Sophy 3/19/2010 QA81-15217 CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	bool		checkCloneMainObj();
	bool		updateLastCloneObjs();
	bool		cloneObj(GraphObject& goSrc, GraphObject& goDst);
	bool		connectObj(GraphObject& goMain, GraphObject& go); //connect without justify, for cloned object
	///end CLONE_MAIN_OBJ_ON_OUTPUT_FOR_ROI_TOOLS
	///Sandy 2008-12-23 add
	void 		getBoundingBoxInfo(string& str);
	//end 

	///------ Foler 04/12/10 QA81-15288 QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
	virtual	BOOL		MakeTree(TreeNode& tr);
	///------ End QUICKFIT_BACKWARD_COMPATIBILITY_FOR_81SR2
};
/// end	GRAPH_OBJ_CURVE_TOOL

///Sophy 6/25/2010 ORG-23-S8 XY_INTERP_FOR_GADGET_TOOL_DLG
typedef struct {
	int	nPlotIndex;
	int ni1;
	int ni2;
	int nMethod;
	int nBoundary;
	double dSmoothFactor;
} InterpParams;

void	OpenInterpXYDlg(InterpParams& stParams);
///end XY_INTERP_FOR_GADGET_TOOL_DLG

#endif // _GROBJ_TOOLS_H_
